using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE.Data
{
    public partial class uc_OutputAdvancedA : ucBase
    {
        public uc_OutputAdvancedA()
        {
            InitializeComponent();

            #region Language added by Edwin
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_OutputAdvancedA_Load(object sender, EventArgs e)
        {
            try
            {
                choIFRMSpeA_CheckedChanged(sender, e);
                choIAdjustedFRMSpeA_CheckedChanged(sender, e);

                label4.Top-=32;
                choFileCA.Top-=32;
                label12.Top -= 32;
                choSpeSpatialFieldA.Top -= 32;
                choSpeSpaGraAdjA.Top -= 32;

                label6.Top -= 64;
                choFileEA.Top -= 64;
                label1.Top -= 64;
                choDVPeriods.Top -= 64;
                label5.Top -= 64;
                choNeiPointA.Top -= 64;
                choNeiSpatialA.Top -= 64;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblSpatialFieldEstimates_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_2output_choices_advanced.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblMiscellaneousOutputs_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_2output_choices_advanced.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choIFRMSpeA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choIFRMSpeA.Checked)
                {
                    choBaseOnlyVNA.Checked = false;
                    choFutureOnlyVNA.Checked = false;
                }
                choChangedHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        public void choChangedHeightAndTop()
        {
            bool VNA = true, eVNA = true, DS = true, DSadvance = true;
            VNA = choIFRMSpeA.Checked || choBaseOnlyVNA.Checked || choFutureOnlyVNA.Checked;
            eVNA = choIAdjustedFRMSpeA.Checked || choBaseOnlyEvna.Checked || choFutureOnlyEvna.Checked;
            DS = chkDS.Checked || chkDSOnlyBase.Checked || chkDSOnlyFuture.Checked;
            DSadvance = chkDSAdvance.Checked;

            //the default location when all controls are expanded
            int thisheight = 1075;
            int pnlTopHeight = 517;
            int pnlVNATop = 102;
            int choEVNATop = 133;
            int pnlEVNATop = 183;
            int chkDSTop = 219;
            int pnlDSTop = 261;
            int pnlDSAdvanceTop = 384;
            int pnlBottom = 526;

            //Calculate the new location
            //top
            int delta = 0;
            if (!VNA) delta = choEVNATop - pnlVNATop;
            choEVNATop -= delta;
            pnlEVNATop -= delta;
            if (!eVNA) delta = chkDSTop - pnlEVNATop;
            chkDSTop -= delta;
            pnlDSTop -= delta;
            pnlDSAdvanceTop -= delta;
            if (!DS)
            {
                delta = pnlTopHeight - pnlDSTop;
                pnlTopHeight -= delta;
            }
            else if (!DSadvance)
            {
                delta = pnlTopHeight - pnlDSAdvanceTop+80;
                pnlTopHeight -= delta;
            }

            //Bottom
            pnlBottom -= delta;
            thisheight -= delta;

            //reset the locations of Controls            
            this.Height = thisheight;
            panel_Top.Height = pnlTopHeight;
            choIAdjustedFRMSpeA.Top = choEVNATop;
            panelEvna.Top = pnlEVNATop;
            chkDS.Top = chkDSTop;
            panelDS.Top = pnlDSTop;
            pnlDSAdvance.Top = pnlDSAdvanceTop;
            panel_bottom.Top = pnlBottom;
            //below are used to invisible the DS options, add by devin,2017-03-09
            //BetaVersion,��Ҫ����DS
            if (CommonClass.BetaVersion)
            {
                chkDS.Enabled = false;
               // panel_bottom.Top = panel_bottom.Top;
                  panel_bottom.Top = panel_bottom.Top - 50;
                pnlInvisibleDS.Top = chkDSTop;
            }
          

            ////old==
            //if ((choIFRMSpeA.Checked || choBaseOnlyVNA.Checked || choFutureOnlyVNA.Checked)
            //    && (choIAdjustedFRMSpeA.Checked || choBaseOnlyEvna.Checked || choFutureOnlyEvna.Checked))
            //{
            //    panel_Top.Height = 216;
            //    panelVNA.Top = 101;
            //    choIAdjustedFRMSpeA.Top = 135;
            //    panelEvna.Top = 185;
            //    panel_bottom.Top = 225;
            //}
            //else if ((choIFRMSpeA.Checked || choBaseOnlyVNA.Checked || choFutureOnlyVNA.Checked)
            //    && (!choIAdjustedFRMSpeA.Checked && !choBaseOnlyEvna.Checked && !choFutureOnlyEvna.Checked))
            //{
            //    panel_Top.Height = 216 - 28;
            //    panelVNA.Top = 101;
            //    choIAdjustedFRMSpeA.Top = 135;
            //    panelEvna.Top = 185;
            //    panel_bottom.Top = 225 - 28;
            //}
            //else if ((!choIFRMSpeA.Checked && !choBaseOnlyVNA.Checked && !choFutureOnlyVNA.Checked)
            //    && (choIAdjustedFRMSpeA.Checked || choBaseOnlyEvna.Checked || choFutureOnlyEvna.Checked))
            //{
            //    panel_Top.Height = 216 - 28;
            //    panelVNA.Top = 101;
            //    choIAdjustedFRMSpeA.Top = 135 - 29;
            //    panelEvna.Top = 185 - 28;
            //    panel_bottom.Top = 225 - 28;
            //}
            //else if ((!choIFRMSpeA.Checked && !choBaseOnlyVNA.Checked && !choFutureOnlyVNA.Checked)
            //    && (!choIAdjustedFRMSpeA.Checked && !choBaseOnlyEvna.Checked && !choFutureOnlyEvna.Checked))
            //{
            //    panel_Top.Height = 216 - 28 - 28;
            //    panelVNA.Top = 101;
            //    choIAdjustedFRMSpeA.Top = 135 - 29;
            //    panelEvna.Top = 185 - 28;
            //    panel_bottom.Top = 225 - 28 - 28;
            //}
        }

        private void choIAdjustedFRMSpeA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choIAdjustedFRMSpeA.Checked)
                {
                    choBaseOnlyEvna.Checked = false;
                    choFutureOnlyEvna.Checked = false;
                }
                choChangedHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choBaseOnlyVNA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choBaseOnlyVNA.Checked)
                {
                    choIFRMSpeA.Checked = false;
                    choFutureOnlyVNA.Checked = false;
                }
                choChangedHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choFutureOnlyVNA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choFutureOnlyVNA.Checked)
                {
                    choIFRMSpeA.Checked = false;
                    choBaseOnlyVNA.Checked = false;
                }
                choChangedHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choBaseOnlyEvna_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choBaseOnlyEvna.Checked)
                {
                    choIAdjustedFRMSpeA.Checked = false;
                    choFutureOnlyEvna.Checked = false;
                }
                choChangedHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choFutureOnlyEvna_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choFutureOnlyEvna.Checked)
                {
                    choIAdjustedFRMSpeA.Checked = false;
                    choBaseOnlyEvna.Checked = false;
                }
                choChangedHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choQuaPointA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doStandardAnalysis == false && choQuaPointA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Point generation requires 'Interpolate monitor data to FRM monitor sites. Temporally-adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choQuaSpatialA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choIFRMSpeA.Checked && !choBaseOnlyVNA.Checked && !choFutureOnlyVNA.Checked && choQuaSpatialA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Spatial Field generation requires 'Interpolate FRM and speciation monitor data to spatial field. Temporally adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choQuaSpaGraAdjA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choIAdjustedFRMSpeA.Checked && !choBaseOnlyEvna.Checked && !choFutureOnlyEvna.Checked && choQuaSpaGraAdjA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Spatial Field - gradient-adjusted generation requires 'Interpolate gradient-adjusted FRM and speciation monitor data to spatial field.Temporally adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choFileCA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doStandardAnalysis == false && choFileCA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("High County Sites generation requires 'Interpolate monitor data to FRM monitor sites. Temporally-adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choSpeSpatialFieldA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choSpeSpatialFieldA.Checked && choNeiSpatialA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Spatial Field Neighbor File generation requires Species Fraction Spatial Field be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choNeiPointA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doStandardAnalysis == false
                    && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doSpeciesFraction == false && choNeiPointA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Point Neighbor File generation requires 'Output species fractions file' and 'Interpolate monitor data to FRM monitor sites. Temporally-adjust.' be checked"), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choNeiSpatialA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choSpeSpatialFieldA.Checked && choNeiSpatialA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Spatial Field Neighbor File generation requires Species Fraction Spatial Field be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choIFRMSpeA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choIFRMSpeA.Checked && !choBaseOnlyVNA.Checked && !choFutureOnlyVNA.Checked && choQuaSpatialA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Spatial Field generation requires 'Interpolate FRM and speciation monitor data to spatial field. Temporally adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choBaseOnlyVNA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choIFRMSpeA.Checked && !choBaseOnlyVNA.Checked && !choFutureOnlyVNA.Checked && choQuaSpatialA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Spatial Field generation requires 'Interpolate FRM and speciation monitor data to spatial field. Temporally adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choFutureOnlyVNA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choIFRMSpeA.Checked && !choBaseOnlyVNA.Checked && !choFutureOnlyVNA.Checked && choQuaSpatialA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Spatial Field generation requires 'Interpolate FRM and speciation monitor data to spatial field. Temporally adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choIAdjustedFRMSpeA_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choIAdjustedFRMSpeA.Checked && !choBaseOnlyEvna.Checked && !choFutureOnlyEvna.Checked && choQuaSpaGraAdjA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Spatial Field - gradient-adjusted generation requires 'Interpolate gradient-adjusted FRM and speciation monitor data to spatial field.Temporally adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choBaseOnlyEvna_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choIAdjustedFRMSpeA.Checked && !choBaseOnlyEvna.Checked && !choFutureOnlyEvna.Checked && choQuaSpaGraAdjA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Spatial Field - gradient-adjusted generation requires 'Interpolate gradient-adjusted FRM and speciation monitor data to spatial field.Temporally adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choFutureOnlyEvna_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choIAdjustedFRMSpeA.Checked && !choBaseOnlyEvna.Checked && !choFutureOnlyEvna.Checked && choQuaSpaGraAdjA.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Base Quarterly PM25 Spatial Field - gradient-adjusted generation requires 'Interpolate gradient-adjusted FRM and speciation monitor data to spatial field.Temporally adjust.' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void chkDS_CheckedChanged(object sender, EventArgs e)
        {
            if (chkDS.Checked)
            {
                chkDSOnlyBase.Checked = false;
                chkDSOnlyFuture.Checked = false;
            }

            if (!chkDS.Checked && !chkDSOnlyBase.Checked && !chkDSOnlyFuture.Checked)
            {
                chkDSAdvance.Checked = false;
            }
            choChangedHeightAndTop();
        }

        private void chkDSOnlyBase_CheckedChanged(object sender, EventArgs e)
        {
            if (chkDSOnlyBase.Checked)
            {
                chkDS.Checked = false;
                chkDSOnlyFuture.Checked = false;
            }
            choChangedHeightAndTop();
        }

        private void chkDSOnlyFuture_CheckedChanged(object sender, EventArgs e)
        {
            if (chkDSOnlyFuture.Checked)
            {
                chkDS.Checked = false;
                chkDSOnlyBase.Checked = false;
            }
            choChangedHeightAndTop();
        }

        private void chkDSAdvance_CheckedChanged(object sender, EventArgs e)
        {
            choChangedHeightAndTop();
        }
    }
}
